package gov.va.genisis2.ts.dto;

import java.io.Serializable;

public class RelationshipClassTypeDTO implements Serializable, Comparable<RelationshipClassTypeDTO> {

	private static final long serialVersionUID = 838171506734451672L;

	private String name;
	private String uri;
	private Boolean isMvpPredicate;

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * @param uri
	 *            the uri to set
	 */
	public void setUri(String uri) {
		this.uri = uri;
	}

	/**
	 * @return the isMvpPredicate
	 */
	public Boolean getIsMvpPredicate() {
		return isMvpPredicate;
	}

	/**
	 * @param isMvpPredicate
	 *            the isMvpPredicate to set
	 */
	public void setIsMvpPredicate(Boolean isMvpPredicate) {
		this.isMvpPredicate = isMvpPredicate;
	}

	/**
	 * sort class object on 'name' attribute
	 */
	public int compareTo(RelationshipClassTypeDTO classType) {
		String localName = (null != classType) ? classType.getName() : null;
		return (null != localName) ? this.name.compareToIgnoreCase(localName) : -1;
	}
}
